#ifndef DEFS_H_INCLUDED
#define DEFS_H_INCLUDED

/* Macros */
#ifndef _DEFAULT_SOURCE
	#define _DEFAULT_SOURCE
#endif
#ifndef _GNU_SOURCE
	#define _GNU_SOURCE
#endif
#ifndef _BSD_SOURCE
	#define _BSD_SOURCE
#endif

/* Version information */
#define VER_MAJOR "0"
#define VER_MINOR "2"
#define VER_PATCH "2"
static const char version[] = VER_MAJOR "." VER_MINOR "." VER_PATCH;

/* Copyright information */
#define PROGRAM_AUTHOR "Bloyburt"
#define COPYRIGHT_YEAR "2024"
static const char copyright[] = PROGRAM_AUTHOR " " COPYRIGHT_YEAR;

/* Define additional colours */
typedef enum extra_colors {
	BRIGHT_RED = 9,
	BRIGHT_GREEN,
	BRIGHT_YELLOW,
	BRIGHT_BLUE,
	BRIGHT_MAGENTA,
	BRIGHT_CYAN,
	BRIGHT_WHITE,
} extraColors;

/* Define colour pairs */
typedef enum color_pair {
	PAIR_RED = 1,
	PAIR_GREEN,
	PAIR_YELLOW,
	PAIR_BLUE,
	PAIR_MAGENTA,
	PAIR_CYAN,
	PAIR_WHITE,
	PAIR_BR_RED,
	PAIR_BR_GREEN,
	PAIR_BR_YELLOW,
	PAIR_BR_BLUE,
	PAIR_BR_MAGENTA,
	PAIR_BR_CYAN,
	PAIR_BR_WHITE
} colorPair;

/* Define main window width and height */
#define WINDOW_WIDTH (35)
#define WINDOW_HEIGHT (21)

/* Define subwindow width and height */
#define CUPWIN_WIDTH (21)
#define CUPWIN_HEIGHT (8)
#define STATWIN_WIDTH (9)
#define MSGWIN_HEIGHT (3)

/* Define maximum amount of player money */
#define MAX_MONEY (99999)

/* Define minimum and maximum choices */
#define MIN_CHOICE (1)
#define MAX_CHOICE (3)

/* Enumerate player skills */
typedef enum PLAYER_SKILL {
	SKILL_EASIEST = 0,
	SKILL_EASIER,
	SKILL_EASY,
	SKILL_MEDIUM,
	SKILL_HARD,
	SKILL_HARDER,
	SKILL_HARDEST
} playerSkill;

/* Define highest skill */
#define MAX_SKILL (SKILL_HARDEST)

/* Define game structure */
struct Game {
	unsigned int choice;	/* player choice */
	unsigned int money;	/* player money */
	unsigned int bet;	/* current bet */
	unsigned int correct;	/* correct answer */
	unsigned int goal;	/* target amount */
	unsigned int skill;	/* current skill */
};

#endif
