/* Include Local Libraries */
#include "common.h"	/* Commonly Used Libraries */
#include "defs.h"	/* Global Defines */
#include "setup.h"	/* Setup Curses */

/* Initialise Curses */
void initCurses()
{
	/* Initialise curses */
	initscr();		/* Initialise curses */
	clear();		/* Clear the screen */
	noecho();		/* Don't echo output */
	curs_set(0);		/* Don't show the cursor */
	keypad(stdscr, true);	/* Enable the keypad */
	refresh();		/* Refresh the screen */
	atexit(exitCurses);	/* Restore normal behaviour on exit */
	/* Check to see if the terminal supports colour */
	if(!has_colors())
	{
		endwin();
		printf("Your terminal does not support colour!\n");
		exit(EXIT_FAILURE);
	}
	/* If it does, then initialise colour and define pairs */
	else
	{
		start_color();
		use_default_colors();
		initColorPairs();
	}
}

/* Initialise Colours */
void initColorPairs()
{
	/* Initialise the regular colour pairs as normal */
	init_pair(PAIR_BLUE, COLOR_BLUE, -1);
	init_pair(PAIR_GREEN, COLOR_GREEN, -1);
	init_pair(PAIR_CYAN, COLOR_CYAN, -1);
	init_pair(PAIR_RED, COLOR_RED, -1);
	init_pair(PAIR_MAGENTA, COLOR_MAGENTA, -1);
	init_pair(PAIR_YELLOW, COLOR_YELLOW, -1);
	init_pair(PAIR_WHITE, COLOR_WHITE, -1);
	/* If more than sixteen colours are available,
	 * create the bright colours and set them */
	if (can_change_color() && COLORS >= 16)
	{
		init_color(BRIGHT_BLUE, 250, 250, 1000);
		init_color(BRIGHT_GREEN, 250, 1000, 250);
		init_color(BRIGHT_CYAN, 250, 1000, 1000);
		init_color(BRIGHT_RED, 1000, 250, 250);
		init_color(BRIGHT_MAGENTA, 1000, 250, 1000);
		init_color(BRIGHT_YELLOW, 1000, 1000, 250);
		init_color(BRIGHT_WHITE, 1000, 1000, 1000);
	}
	if (COLORS >= 16)
	{
		init_pair(PAIR_BR_BLUE, BRIGHT_BLUE, -1);
		init_pair(PAIR_BR_GREEN, BRIGHT_GREEN, -1);
		init_pair(PAIR_BR_CYAN, BRIGHT_CYAN, -1);
		init_pair(PAIR_BR_RED, BRIGHT_RED, -1);
		init_pair(PAIR_BR_MAGENTA, BRIGHT_MAGENTA, -1);
		init_pair(PAIR_BR_YELLOW, BRIGHT_YELLOW, -1);
		init_pair(PAIR_BR_WHITE, BRIGHT_WHITE, -1);
	}
	/* Otherwise, initialise them with normal colours */
	else
	{
		init_pair(PAIR_BR_BLUE, COLOR_BLUE, -1);
		init_pair(PAIR_BR_GREEN, COLOR_GREEN, -1);
		init_pair(PAIR_BR_CYAN, COLOR_CYAN, -1);
		init_pair(PAIR_BR_RED, COLOR_RED, -1);
		init_pair(PAIR_BR_MAGENTA, COLOR_MAGENTA, -1);
		init_pair(PAIR_BR_YELLOW, COLOR_YELLOW, -1);
		init_pair(PAIR_BR_WHITE, COLOR_WHITE, -1);
	}
}

/* Delete Windows */
void deleteWindows(WINDOW *mainWindow, WINDOW *cupWindow,
		WINDOW *statWindow, WINDOW *msgWindow)
{
	/*/ Delete the subwindows, then the main window */
	delwin(cupWindow);
	delwin(statWindow);
	delwin(msgWindow);
	delwin(mainWindow);
}

/* Exit Curses */
void exitCurses()
{
	/* Free curses and restore normal prompt behaviour */
	endwin();
}
